    #include "package.h"

//constructeur par defaut
Package::Package()
{
    this->m_iBufferLenght =  0;
    this->m_pBuffer =(char *) malloc(1000);
    this->m_pCourant = this->m_pBuffer;
}
        
// destructeur
Package::~Package()
{
    delete this->m_pBuffer;
}   

void Package::displayPackage()
{
    char *c;
    c = this->m_pBuffer;
    for (int i = 0; i<this->m_iBufferLenght; i++, c++)
    {
        printf("%d-",*c);
    }
    printf("\n");
    system("PAUSE");
}
  
// ajoute les evnements de la listeEvent pour le joueur
// numJoueur dans le buffer du package
void Package::addEvents(int numJoueur, vector<char>* listeEvent)
{
    vector<char>::iterator i;
    
    // verifie que numJoueur ne dpasse pas le grosseur d'un char
    if (numJoueur >=256)
    {
        numJoueur=255;
    }
    
    // ajout du numro du joueur
    *(this->m_pCourant++)  = (char) numJoueur;
    this->m_iBufferLenght++;
    
    // ajout des vnements
    for (i=listeEvent->begin(); i != listeEvent->end(); i++)
    {
        *(this->m_pCourant++) = *i;
        this->m_iBufferLenght++;
    }
    
    //ajout du zero : caractere de fin des vnements d'un joueur
     *(this->m_pCourant++) = 0;
    this->m_iBufferLenght++;
}
        
// efface toutes le informations du buffer
void Package::clearPackage()
{
    this->m_pCourant = this->m_pBuffer;
    this->m_iBufferLenght=0;
}
        
// retourne le buffer dans lequel est sock les vmenent 
// a envoyer sur le rseau
char * Package::getBuffer()
{
    return this->m_pBuffer;
}
        
// retourne la longueur du buffer en octets
int Package::getBufferLenght()
{
    return this->m_iBufferLenght;
}
